/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.io;

import de.willuhn.logging.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static long copy(InputStream is, OutputStream os) throws IOException {
        byte[] b = new byte[4096];
        long r = 0L;
        int read = 0;
        while ((read = is.read(b)) != -1) {
            if (read <= 0) continue;
            os.write(b, 0, read);
            r += (long)read;
        }
        return r;
    }

    public static boolean close(Closeable ... closeables) {
        boolean ok = true;
        if (closeables == null || closeables.length == 0) {
            return ok;
        }
        for (Closeable c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (Throwable t) {
                Logger.error("error while closing stream", t);
                ok = false;
            }
        }
        return ok;
    }
}

